<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Resturant extends Model 
{

    protected $table = 'resturants';
    public $timestamps = true;

    public function tables()
    {
        return $this->hasMany('App\Models\ResturantTable');
    }

    public function menuItems()
    {
        return $this->hasMany('App\Models\MenuItem');
    }

    public function menuSections()
    {
        return $this->hasMany('App\Models\MenuSection');
    }

    public function sections()
    {
        return $this->hasMany('App\Models\ResturantSection');
    }

    public function employees()
    {
        return $this->hasMany('App\Models\Employee');
    }

    public function shifts()
    {
        return $this->hasMany('App\Models\Shift');
    }

    public function reservations()
    {
        return $this->hasMany('App\Models\Reservation');
    }

    public function orders()
    {
        return $this->hasMany('App\Models\Order');
    }

    public function promotions()
    {
        return $this->hasMany('App\Models\Promotion');
    }

    public function paymentWays()
    {
        return $this->hasMany('App\Models\PaymentWay');
    }

    public function attendances()
    {
        return $this->hasMany('App\Models\Attendance');
    }

    public function reviews()
    {
        return $this->hasMany('App\Models\Review');
    }

    public function admins()
    {
        return $this->hasMany('App\Models\Admin');
    }

}